; magOexp.jss
; MAGic tracking functions for both versions of Outlook Express
Include "hjconst.jsh"
include "msimnui.jsh"
Include "hjglobal.jsh"
Include "magic.jsh"


Const
	wcList32 = "SysListView32"


Void Function NewTextMagEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
Var
  String TheClass, String cwClass, Int cwID,  Int TheTypeCode, Int nH, Int nX, Int nY, Int bSuccess,
	Int nL, Int nR, Int nT, Int nB
If ((GlobalMenuMode == MENU_ACTIVE) || (GlobalMenuMode == MENUBAR_ACTIVE)) then Return EndIf
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
let TheClass = GetWindowClass(hwnd)
let TheTypeCode = GetWindowSubtypeCode (hwnd)
If !(StringContains (NewTextSetFocusWindows + wcList32 +  "| " + mWN_OE5_ATL, TheClass) || StringContains (NewTextSetFocusWindows, strWT_ + IntToString (TheTypeCode))) then Return EndIf  
Let cwClass = GetWindowClass (GetCurrentWindow ())
Let cwID = GetCurrentControlID ()
If (cwID == 864052) then Return EndIf
If (cwClass == mWN_STV32) then Return EndIf
if (TheClass == mWN_AltTab) then
  If (!GetWindowRect (hwnd, nL, nR, nT, nB)) then
    return
  endif
  let nH = nB - nT
  let nT = nT + ((50 * nH) / 100)
  MagSetFocusToRect (nL, nR + 10, nT, nB + 5, MTO_GENERIC)
  return
; This block of code is designed to handle combo list boxes, specifically the combo list box in Windows Explorer
ElIf (TheClass == mWN_ComboLBox) then
  If (nAttributes & ATTRIB_HIGHLIGHT) then
    GetFocusRect (hwnd, nL, nR, nT, nB)
    MagSetFocusToRect (nL - 5, nR + 5, nT - 5, nB + 5, MTO_DIALOG)
    Return
  EndIf
  Return
ElIf (StringContains (TheClass, strSLV)) then
  If (nAttributes & ATTRIB_HIGHLIGHT) then
    Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
    If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_LINE) EndIf
    If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) Let nR = GetWindowRight (GetCurrentWindow ()) EndIf
    MagSetFocusToRect (nL - 5, nR + 5, nT - 5, nB + 5, MTO_CARET)
    Return
  EndIf
  Return
Else
  If (nAttributes & ATTRIB_HIGHLIGHT) then
    GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK)
    MagSetFocusToRect (nL - 5, nR + 5, nT - 5, nB + 5, MTO_GENERIC)
    Return
  EndIf
EndIf
EndFunction

Void Function FocusChangedMagEvent (handle FocusWindow, handle PrevWindow)
;  This function is designed to handle all MAGic specific processing that must occur
;  when the focus changes.  The window handles of the previous and new windows
;  are passed to this function to aid in the analysis of the focus change.
Var String cwClass, Int nX, Int nY, Int bSuccess, Int nL, Int nR, Int nT, Int nB
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Let bSuccess = FALSE
Let cwClass = GetWindowClass (GetCurrentWindow ())
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
If (cwClass == mWN_STV32) then
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD)
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
  Let nR = GetWindowRight (GetCurrentWindow ())
  If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
  If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
  MagSetFocusToRect (nL, nR, nT, nB + 1, MTO_GENERIC)
  Return
ElIf (cwClass == wc_List || cwClass == wc_ListView) then
    Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
    If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_LINE) EndIf
    If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) Let nR = GetWindowRight (GetCurrentWindow ()) EndIf
    MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_CARET)
    Return
ElIf ((cwClass == mWN_IEWin) && (GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE)) then
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
  If (!bSuccess) then GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (bSuccess) then MagSetFocusToRect (nL, nR, nT, nB, MTO_CARET)
  Else MagSetFocusArea (nX, nY, 0, 0, 0, 0, 0) EndIf
ElIf ((cwClass == mWN_IEWin) && (GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == TRUE)) then
  TrackEditWindow (nX, nY, 0, 0, 0, 0, 0, GetWindowSubtypeCode (GetCurrentWindow ()), cwClass, GetAppMainWindow (GetCurrentWindow ()))
Else MagSetFocusArea (nX, nY, 0, 0, 0, 0, 0) EndIf
EndFunction

Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;  This function first tests for the existance of MAGic.  If MAGic is running, it then determines
;  the current window type.  If the current window type is an edit Window, it calls
;  SetMagicFocusArea to set the focus to a region surrounding the cursor position.
;  Test to determine if there is an application specific setting in the jcf file to disable the JFW tracking engine.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Var String cwClass, Int bSuccess, Int nL, Int nR, Int nT, Int nB
If (DidControlChange () == 1) then Return EndIf
If (GetCursorCol () - nX == 1) then Let nX = nX + 1 EndIf
Let bSuccess = FALSE
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (cwClass == mWN_STV32) then
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD)
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
  Let nR = GetWindowRight (GetCurrentWindow ())
  If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
  If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
  MagSetFocusToRect (nL, nR, nT, nB + 1, MTO_GENERIC)
  Return
ElIf (cwClass == wc_List || cwClass == wc_ListView) then
    Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
    If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_LINE) EndIf
    If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) Let nR = GetWindowRight (GetCurrentWindow ()) EndIf
    MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_CARET)
    Return
ElIf ((cwClass == mWN_IEWin) && (GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE)) then
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
  If (!bSuccess) then GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (bSuccess) then MagSetFocusToRect (nL, nR, nT, nB, MTO_CARET)
  Else MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed) EndIf
ElIf ((cwClass == mWN_IEWin) && (GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == TRUE)) then
  TrackEditWindow (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, GetWindowSubtypeCode (GetCurrentWindow ()), cwClass, GetAppMainWindow (GetCurrentWindow ()))
Else MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed) EndIf
EndFunction

